clear all
close all
load beta.mat
global eta i_app tem conc_o concS_o sv sigmaEffFACE porosityNODE diffuFACE...
       dx n_n n_s n_t n_p nr dt FARADAY RU porosity_n porosity_s porosity_p poroActive_n poroActive_p...
       diffu diffuSolid_n diffuSolid_p tPlus R_s alpha_a alpha_c concS_max_n...
       concS_max_p kcon_n kcon_p sigma_n sigma_p A_csp A_csn A_cs A_phie A_ce A_phis A jli stoic_p
       
%% Set up grid parameter, material properties, and initial conditions
    % -------------------------------------------------------------------------
    % Charging / Discharging Condition
    charge = false;              % Initially Assume Charging Cycle
    % -------------------------------------------------------------------------
    % Hybrid Cycle
    hybrid_cycle = false;
    % -------------------------------------------------------------------------
    % Simulation Time 
    time =3600;               	% Simulation End Time [UNIT: seconds]
    % -------------------------------------------------------------------------
settings;
%% preallocation 
           Cs=zeros(time,nr*(n_n+n_p));
           Ce=zeros(time,n_t);
           Phie=zeros(time,n_t);
           Phis=zeros(time,n_n+n_p);
           Cse=zeros(time,n_t);
           F_phis1=zeros((n_n+n_p),1);
           J_phis1=zeros((n_n+n_p),(n_n+n_p));
           F_ce1=zeros(n_t,1);
           J_ce1=spalloc(n_t,n_t,n_t*3-2);
           F_phie1=zeros(n_t,1);
           J_phie1=spalloc(n_t,n_t,n_t*3-2);
           F_cs1=zeros(nr*(n_n+n_p),1);
           J_cs1=spalloc(nr*(n_n+n_p),nr*(n_n+n_p),nr*(n_n+n_p)*3-2);
           A_csn = spalloc(nr,nr,3*nr-2);
           A_csp = spalloc(nr,nr,3*nr-2);
           A_cs = spalloc(nr*(n_n+n_p),nr*(n_n+n_p),3*nr*(n_n+n_p)-2);
           A_phie=zeros(n_t,n_t);%% preallocation
           A_ce=zeros(n_t,n_t);%% preallocation
           A_phis=zeros(n_n+n_p,n_n+n_p);%% preallocation
           jli_dis=[];
%% define control variables
tol=1e-4; %% tolerance
alpha=0.5; %% damping ratio
%% define the sub functions 
F_cs='bat_F_cs';
F_ce='bat_F_ce';
F_phie='bat_F_phie';
F_phis='bat_F_phis';
J_cs='bat_cs_J';
J_ce='bat_ce_J';
J_phie='bat_phie_J';
J_phis='bat_phis_J';
%% define input of the subfunctions
% x(1:n_n)=stoic_n;
% y(1:n_t)=stoic_p;
% delta_y(1:n_t)=1e-4;
y_in=[phiS,phiE,conc,concS,concS_surf];
tic
for t=1:time_max
    t*dt
   for iter=1:iter_max
       loop_eqpot;
       %%%%%%%%% phis %%%%%%%%%%%%
       F_phis1=feval(F_phis,y_in);
       J_phis1=feval(J_phis,y_in);
       delta1=J_phis1\(-F_phis1);
       phiS=y_in(1:n_n+n_p);
       y1=phiS;
       phiS=phiS+(alpha*delta1)';
       dif(1)=norm(phiS-y1);
       for i=1:n_n+n_p   
           phiS(i)=min(max(phiS(i),phiS_min),phiS_max);
       end      
       etas;
       y_in=[phiS,phiE,conc,concS concS_surf];
       %%%%%%%%% phie %%%%%%%%%%%%
       F_phie1=feval(F_phie,y_in);
       J_phie1=feval(J_phie,y_in);
       delta2=J_phie1\(-F_phie1);
       phiE=y_in(1+n_n+n_p:n_n+n_p+n_t);
       y2=phiE;
       phiE=phiE+(alpha*delta2)';
       dif(2)=norm(phiE-y2);
       for i=1:n_t
           phiE(i)=min(max(phiE(i),phiE_min),phiE_max);
       end 
       etas;
       y_in=[phiS,phiE,conc,concS concS_surf];
       %%%%%%%%% conc %%%%%%%%%%%%       
       F_ce1=feval(F_ce,y_in);
       J_ce1=feval(J_ce,y_in);
       delta3=J_ce1\(-F_ce1);
       conc=y_in(n_n+n_p+n_t+1:n_n+n_p+n_t+n_t);
       y3=conc;
       conc=conc+(alpha*delta3)';
       dif(3)=norm(y3-conc);
       for i=1:n_t
           conc(i)=min(max(conc(i),conc_min),conc_max);
       end
       y_in=[phiS,phiE,conc,concS concS_surf];
       %%%%%%%%% concS %%%%%%%%%%%% 
       F_cs1=feval(F_cs,y_in);
       J_cs1=feval(J_cs,y_in); 
       delta4=J_cs1\(-F_cs1);
       concS=y_in(1+n_n+n_p+n_t+n_t:n_n+n_p+n_t+n_t+nr*(n_n+n_p));
       y4=concS;
       concS=concS+(alpha*delta4)';
       dif(4)=norm(y4-concS);
       for i=1:nr*n_n
           concS(i)=min(max(concS(i),conc_min),concS_max_n);
       end
       for i=n_n*nr+1:nr*(n_n+n_p)
           concS(i)=min(max(concS(i),conc_min),concS_max_p);
       end
       for i=1:n_n
           concS_surf(i)=concS(i*nr);
           concS_surf(i) = min(max(conc_min,concS_surf(i)),concS_max_n );
       end
       for i=n_n+1:n_n+n_p
           j=i+n_s;
           concS_surf(j)=concS((i)*nr);
           concS_surf(j) = min(max(conc_min,concS_surf(j)),concS_max_p );
       end 
%           x=concS_surf(1:n_n)./concS_max_n;
%           y=concS_surf(1:n_t)./concS_max_p;
%           delta_y(1:n_t)=1e-4;
       y_in=[phiS,phiE,conc,concS concS_surf];
       check;
       if iter==iter_max
           disp('NOT converged')
           return;
       end
       if converged==true

           disp('converged')
           Cs(t,:)=concS;
           Ce(t,:)=conc;
           Phie(t,:)=phiE;
           Phis(t,:)=phiS;
           Cse(t,:)=concS_surf;
           break;
       end
    end  
    time_march; 
    post;
     jli_dis=[jli_dis;jli'];
%    x=concS_surf(1:n_n)./concS_max_n;
%    y=concS_surf(1:n_t)./concS_max_p;
end
time_consumed=toc
% %%
% figure,
% subplot(2,2,1),
% plot(Cs(:,1));
% title(['concentration at 0'])
% subplot(2,2,2),
% plot(Cs(:,6));
% title(['concentration at ' num2str(R_s/11*6,'%10.3e\n')])
% subplot(2,2,3),
% plot(Cs(:,11));
% title(['concentration at ' num2str(R_s,'%10.3e\n')])
% subplot(2,2,4),
% mesh(Cs(:,1:11));
% xlabel('r-axis'),ylabel('time')
% suptitle(['Concentration of solid solved by jacobian matrix with damped coffiecience =' num2str(alpha) 'consumed time = ' num2str(time)])
% figure,
% subplot(2,2,1),
% plot(Ce(:,1));
% title(['concentration at ' 0])
% subplot(2,2,2),
% plot(Ce(:,50));
% title(['concentration at ' num2str((l_n+l_s*6/n_s),'%10.3e\n')])
% subplot(2,2,3),
% plot(Ce(:,end));
% title(['concentration at ' num2str(l_n+l_s+l_p,'%10.3e\n')])
% subplot(2,2,4),
% mesh(Ce);
% xlabel('x-axis'),ylabel('time')
% suptitle(['Concentration of solution solved by jacobian matrix with damped coffiecience=' num2str(alpha)])
% figure,
% subplot(2,2,1),
% plot(Phie(:,1));
% title(['Potential in solution phase at 0' ])
% subplot(2,2,2),
% plot(Phie(:,50));
% title(['Potential in solution phase at ' num2str((l_n+l_s*6/n_s),'%10.3e\n')])
% subplot(2,2,3),
% plot(Phie(:,end));
% title(['Potential in solution phase at ' num2str(l_n+l_s+l_p,'%10.3e\n')])
% subplot(2,2,4),
% mesh(Phie);
% xlabel('x-axis'),ylabel('time')
% suptitle(['potential of solution solved by jacobian matrix with damped coffiecience=' num2str(alpha)])
% figure,
% subplot(2,2,1),
% plot(Phis(:,1));
% title(['Potential in solid phase at 0' ])
% subplot(2,2,2),
% plot(Phis(:,50));
% title(['Potential in solid phase at ' num2str((l_n),'%10.3e\n')])
% subplot(2,2,3),
% plot(Phis(:,end));
% title(['Potential in solid phase at ' num2str(l_n+l_s+l_p,'%10.3e\n')])
% subplot(2,2,4),
% mesh(Phis);
% xlabel('x-axis'),ylabel('time')
% suptitle(['potential of solid solved by jacobian matrix with damped coffiecience=' num2str(alpha)])
% figure,
% subplot(2,2,1),plot(Cse(:,1))
% title(['concentration at ' 0])
% subplot(2,2,2),plot(Cse(:,56))
% title(['concentration at ' num2str((l_n+l_s*6/n_s),'%10.3e\n')])
% subplot(2,2,3),plot(Cse(:,end))
% title(['concentration at ' num2str(l_n+l_s+l_p,'%10.3e\n')])
% subplot(2,2,4),mesh(Cse)
% xlabel('x-axis'),ylabel('time')
% suptitle(['Surface Concentrate of particle solved by jacobian matrix with damped coffiecience=' num2str(alpha)])
% %% plot the input current and output voltage
% if(hybrid_cycle) 
%     figure,
%     plot(app_curr);
%     xlabel('time (sec)'),ylabel( 'current(A)');
%     ylim([-20 35])
%     title('The HPPC current')
% end
% figure,
% plot(cell_voltage);
% xlabel('time (sec)'),ylabel('Voltage (V)');
% ylim([3 4])
% title(['The terminal cell voltage with time consumed=', num2str(time)])
% %%%%%%%%%%%%%%%%%%%%%% surface concentration %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% %%
% figure,
% plot([linspace(0,l_n,n_n) l_n+linspace(0,l_s,n_s) l_n+l_s+linspace(0,l_p,n_p)]./(l_n+l_s+l_p),Cse(time_max/time_max,:)./concS_maxNODE);
% hold on
% plot([linspace(0,l_n,n_n) l_n+linspace(0,l_s,n_s) l_n+l_s+linspace(0,l_p,n_p)]./(l_n+l_s+l_p),Cse(time_max/10,:)./concS_maxNODE);
% hold on
% plot([linspace(0,l_n,n_n) l_n+linspace(0,l_s,n_s) l_n+l_s+linspace(0,l_p,n_p)]./(l_n+l_s+l_p),Cse(time_max/5,:)./concS_maxNODE);
% hold on
% plot([linspace(0,l_n,n_n) l_n+linspace(0,l_s,n_s) l_n+l_s+linspace(0,l_p,n_p)]./(l_n+l_s+l_p),Cse(time_max/2,:)./concS_maxNODE);
% hold on
% plot([linspace(0,l_n,n_n) l_n+linspace(0,l_s,n_s) l_n+l_s+linspace(0,l_p,n_p)]./(l_n+l_s+l_p),Cse(time_max,:)./concS_maxNODE);
% xlabel('x/L'),ylabel( 'Cs,e/Cs_max');
% legend([num2str(time_max/time_max)],[num2str(time_max/10)],[num2str(time_max/5)],[num2str(time_max/2)],[num2str(time_max)])
% title('surface concentraion')
% 
%%
% z_p=alf*y_p+bet;
% EMF=U2-U1;
% plot(1-z_p,U2-U1,'LineWidth',2)
% hold on
% plot(1-socgrd,EMFtmp(socgrd),'LineWidth',2)
% legend('Model','experimental')
% title('OCV');
% %%
% EMF_int=interp1(z_p,EMF,socgrd,'linear','extrap');
% EMF_exp=EMFtmp(socgrd);
% % figure(11)
% % plot(1-socgrd,EMF_int);
% % hold on
% % plot(1-socgrd,EMFtmp(socgrd),'LineWidth',2)
% error=abs(EMF_int-EMFtmp(socgrd))./(EMF_exp(end:-1:1));
% figure(22)
% plot(error);

